/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.parts;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.parts.TextPart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.util.ProgressMonitor;
import java.rmi.RemoteException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ProgressBar
implements ProgressMonitor,
Part {
    private int status = 1;
    private boolean showLogs = true;
    private boolean showPercent = false;
    private TextPart log = null;
    private Composite parent = null;
    private org.eclipse.swt.widgets.ProgressBar bar = null;
    private Label barLabel = null;
    private Label percentLabel = null;
    private int current = 0;

    public void setPercentComplete(int percent) {
        if (percent < 0) {
            percent = 0;
        }
        if (percent > 100) {
            percent = 100;
        }
        this.current = percent;
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBar.this.bar != null && !ProgressBar.this.bar.isDisposed()) {
                    ProgressBar.this.bar.setSelection(ProgressBar.this.current);
                }
                if (ProgressBar.this.percentLabel != null && !ProgressBar.this.percentLabel.isDisposed()) {
                    ProgressBar.this.percentLabel.setText(" [" + ProgressBar.this.current + " %]");
                }
            }
        });
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatusText(final String text) {
        if (text == null) {
            return;
        }
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBar.this.barLabel != null && !ProgressBar.this.barLabel.isDisposed()) {
                    ProgressBar.this.barLabel.setText(text);
                    ProgressBar.this.log(text);
                    if (ProgressBar.this.status == 4) {
                        ProgressBar.this.barLabel.setForeground(Color.SUCCESS.getSWTColor());
                    } else if (ProgressBar.this.status == 3 || ProgressBar.this.status == 5) {
                        ProgressBar.this.barLabel.setForeground(Color.ERROR.getSWTColor());
                    } else {
                        ProgressBar.this.barLabel.setForeground(Color.FOREGROUND.getSWTColor());
                    }
                    ProgressBar.this.barLabel.redraw();
                    ProgressBar.this.barLabel.update();
                }
            }
        });
    }

    public void log(final String msg) {
        if (!this.showLogs || msg == null) {
            return;
        }
        GUI.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBar.this.log != null) {
                    ProgressBar.this.log.appendText(msg);
                }
            }
        });
    }

    public void clearLog() {
        if (!this.showLogs || this.log == null) {
            return;
        }
        this.log.clear();
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        this.parent = new Composite(parent, 0);
        this.parent.setLayout((Layout)new GridLayout(this.showLogs ? 3 : 2, false));
        this.parent.setLayoutData((Object)new GridData(1808));
        if (this.showLogs) {
            this.bar = new org.eclipse.swt.widgets.ProgressBar(this.parent, 65536);
            GridData gd = new GridData(32);
            gd.widthHint = this.showPercent ? 100 : 150;
            this.bar.setLayoutData((Object)gd);
            this.bar.setMaximum(100);
            this.bar.setSelection(0);
            if (this.showPercent) {
                this.percentLabel = GUI.getStyleFactory().createLabel(this.parent, 0);
                gd = new GridData(32);
                gd.widthHint = 50;
                this.percentLabel.setLayoutData((Object)gd);
                this.percentLabel.setText(" [0 %]");
            }
            this.barLabel = GUI.getStyleFactory().createLabel(this.parent, 0);
            gd = new GridData(768);
            gd.horizontalSpan = this.showPercent ? 1 : 2;
            this.barLabel.setLayoutData((Object)gd);
            this.barLabel.setText("");
            Composite comp = new Composite(this.parent, 2048);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            gl.horizontalSpacing = 0;
            gl.verticalSpacing = 0;
            comp.setLayout((Layout)gl);
            GridData gd2 = new GridData(1808);
            gd2.horizontalSpan = 3;
            comp.setLayoutData((Object)gd2);
            this.log = new TextPart();
            this.log.setAutoscroll(true);
            this.log.setWordWrap(false);
            this.log.paint(comp);
        } else {
            this.barLabel = GUI.getStyleFactory().createLabel(this.parent, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalIndent = 2;
            this.barLabel.setLayoutData((Object)gd);
            this.barLabel.setText("");
            this.bar = new org.eclipse.swt.widgets.ProgressBar(this.parent, 65536);
            gd = new GridData(768);
            gd.horizontalSpan = this.showPercent ? 1 : 2;
            this.bar.setLayoutData((Object)gd);
            this.bar.setMaximum(100);
            this.bar.setSelection(0);
            if (this.showPercent) {
                this.percentLabel = GUI.getStyleFactory().createLabel(this.parent, 0);
                gd = new GridData(32);
                gd.widthHint = 50;
                this.percentLabel.setLayoutData((Object)gd);
                this.percentLabel.setText(" [0 %]");
            }
        }
    }

    public void addPercentComplete(int percent) {
        if (percent < 1) {
            return;
        }
        this.setPercentComplete(this.getPercentComplete() + percent);
    }

    public int getPercentComplete() {
        return this.current;
    }

    public void showLogs(boolean show) {
        this.showLogs = show;
    }

    public void showPercent(boolean show) {
        this.showPercent = show;
    }
}

